{% set atom_django = pillar['django'] %}

atom_django.user:
  user.present:
    - name: {{ atom_django['user'] }}
    - home: {{ atom_django['home'] }}
    - shell: /bin/false

atom_django.venv:
  virtualenv.managed:
    - name: {{ atom_django['venv_dir'] }}
    - system_site_packages: True
    - require:
      - pkg: python
      - user: atom_django.user

python-pip:
  pkg.installed:
    - names:
        - python-pip
        - python-openssl
        - python-pyasn1
        - python-setuptools
        - python-dev

atom_django.pip:
  pip.installed:
    - bin_env: {{ atom_django['venv_dir'] }}
    - index_url: https://pypi.yandex-team.ru/simple/
    - requirements: salt://atom_django/requirements.txt
    - require:
      - virtualenv: atom_django.venv
      - pkg: python-pip

skynet:
  pkg.installed:
    - name: yandex-gosky

atom_django.nginx.conf:
  file.managed:
    - name: /etc/nginx/sites-enabled/atom_django.conf
    - source: salt://atom_django/nginx.conf
    - context: # помимо переменных вроде pillar, мы можем передать дополнительный контекст для тепмлейта
        bind: "{{atom_django['primary_machine']}}:{{atom_django['gunicorn_port']}}"
        #dns_name: {{ atom_django['dns_name'] }}
    - template: jinja
    - makedirs: True
    - watch_in:
      - service: nginx

redis-server:
    pkg.installed: []

    service.running:
        - require:
            - pkg: redis-server

memcached:
    pkg.installed: []
    service.running:
        - require:
            - pkg: memcached

atom_django.supervisor.conf:
  file.managed:
    - name: /etc/supervisor/conf.d/atom_django.conf
    - source: salt://atom_django/supervisor/gunicorn.conf
    - context:
        app_name: atom_django
        bind: "{{ atom_django['gunicorn_bind'] }}"
        gunicorn: {{ atom_django['venv_dir'] }}/bin/gunicorn
        directory: {{ atom_django['work_dir'] }}/app
    - template: jinja
    - makedirs: True

celery.supervisor.conf:
  file.managed:
    - name: /etc/supervisor/conf.d/celery.conf
    - source: salt://atom_django/supervisor/celery.conf
    - context:
        app_name: celery
        celery: {{ atom_django['venv_dir'] }}/bin/celery
        directory: {{ atom_django['work_dir'] }}/app
    - template: jinja
    - makedirs: True

source_code:
  file.recurse:
    - name: {{ atom_django['work_dir'] }}/app
    - source: salt://atom_django/app
    - user: atom_admin
    - require:
      - user: atom_django.user

local_settings:
  file.managed:
      - source: salt://atom_django/local_settings.py
      - name: {{ atom_django['work_dir'] }}/app/switch/local_settings.py
      - template: jinja
      - require:
          - file: source_code
 

django-admin migrate:
  module:
    - run
    - name: django.command
    - command: migrate
    - bin_env: {{ atom_django['venv_dir'] }}
    - settings_module: switch.settings
    - pythonpath: {{ atom_django['work_dir'] }}/app
    - require:
      - virtualenv: atom_django.venv
      - file: local_settings
      - postgres_database: postgresql_database_setup

querydata_indexer:
    file.managed:
        - name: /usr/bin/querydata_indexer
        - source: http://proxy.sandbox.yandex-team.ru/115808732
        - source_hash: md5=e54c9997e4fd999b2cfcc02f1aff029e
        - mode: '0755'

mapreduce:
  pkg.installed:
    - name: yandex-quality-mapreduce-unstable

celery.supervisor:
  file.directory:
    - name: /var/log/celery
  supervisord.running:
    - name: celery
    - watch:
        - file: celery.supervisor.conf
    - require:
        - service: redis-server
        - service: memcached
        - file: celery.supervisor
        - pkg: mapreduce

atom_django.supervisor:
  supervisord.running:
    - name: atom_django
    - watch:
      - file: atom_django.supervisor.conf
      - file: source_code
      - file: local_settings
    - require:
      - pip: atom_django.pip
      - pkg: supervisor
      - pkg: skynet
      - file: querydata_indexer
      - service: redis-server
      - service: postfix
      - file: celery.supervisor # because supervisor may fail to start without it

# vim:set ft=yaml:
