mysql:
    pkg:
        - installed
        - names:
            - mysql-server
    service:
        - running
        - require:
            - pkg: mysql-server
    mysql_database.present:
        - name: atom_admin
        - character_set: utf8
        - collate: utf8_bin
        - require:
            - service: mysql
    mysql_user.present:
        - name: atom_django
        - password: {{ pillar['django']['mysqlpw'] }}
    mysql_grants.present:
        - user: atom_django
        - grant: all privileges
        - database: atom_admin.*
        - require:
            - mysql_user: mysql
            - mysql_database: mysql
# vim:set ft=yaml:
