{% set db_user = pillar['django']['db_user'] %}
{% set db_pass = pillar['django']['db_pass'] %}
{% set db_name = pillar['django']['db_name'] %}

postgresql:
  pkg.installed:
    - names:
      - libpq-dev
      - postgresql-9.4

  service.running:
    - watch:
      - file: /etc/postgresql/9.4/main/pg_hba.conf
    - require:
      - pkg: postgresql

  file.managed:
    - name: /etc/postgresql/9.4/main/pg_hba.conf
    - source: salt://postgresql/pg_hba.conf.template
    - template: jinja
    - require:
      - pkg: postgresql

postgresql_conf:
  file.blockreplace:
    - name: /etc/postgresql/9.4/main/postgresql.conf
    - marker_start: "# START managed zone -DO-NOT-EDIT-"
    - marker_end: "# END managed zone --"
    - content: |
        listen_addresses = 'localhost,{{grains['fqdn']}}'
        wal_level = 'hot_standby'
        archive_mode = on
        archive_command = 'cd .'
        max_wal_senders = 1
        wal_keep_segments = 50
        hot_standby = on
    - append_if_not_found: True
    - backup: '.bak'
    - show_changes: True
    - require:
      - pkg: postgresql

postgresql_replication_user:
  postgres_user.present:
    - name: rep
    - password: {{pillar['django']['db_replication_pass']}}
    - replication: True
    - login: True
    - user: postgres
    - require:
      - service: postgresql

postgresql_database_setup:
  postgres_user.present:
    - name: {{ db_user }}
    - password: {{ db_pass }}
    - createdb: True
    - user: postgres
    - require:
      - service: postgresql

  postgres_database.present:
    - name: {{ db_name }}
    - encoding: UTF8
    - lc_ctype: en_US.UTF8
    - lc_collate: en_US.UTF8
    - template: template0
    - owner: {{ db_user }}
    - user: postgres
    - require:
      - postgres_user: postgresql_database_setup

trigger_file:
{% if grains['fqdn'] == pillar['django']['primary_machine'] %}
    file.managed:
{% else %}
    file.absent:
{% endif %}
        - name: "/tmp/postgresql.trigger.5432"
        - require_in:
            - service: postgresql
