from tasklet.api import tasklet_pb2
from tasklet.basic.proto import remote_exec_tasklet


class RemoteExecImpl(remote_exec_tasklet.RemoteExecBase):

    def run(self):
        instance = tasklet_pb2.JobInstance()
        instance.statement.CopyFrom(self.input)
        instance.parent_id = ""

        tasklet_id = self.ctx.sched.instance(instance)
        self.ctx.sched.schedule(tasklet_id)
        self.ctx.sched.wait_for(tasklet_id)
        status = next(self.ctx.sched.status(tasklet_id))
        self.output.CopyFrom(status.result)
