"""
Tests that should be run during import tests
"""

from __future__ import unicode_literals

import sys

from tasklet.runtime import dispatch


# Please do not create new tasklets using Python 2.
# But if you really need to use Python 2 for new tasklet then you should add tasklet names to the list below
# with the mention (in comment) of task in Tracker on migration to Python 3.
PY2_TASKLETS_ALLOW_LIST = [
    "AddNewDevicesToDb",
    "AddTvDevicesToDb",
    "AggregateMetrics",
    "Autocheck",
    "AwaitTask",
    "BackendSnapshotsHandler",
    "BackupArcTables",
    "BackupPgSnapshot",
    "BuildAndUploadTaskletBinary",
    "BuildDebianPackage",
    "BuildPackage",
    "BuildTarballForDeploy",
    "CheckIdTask",
    "CompareTask",
    "ConvertMetrics",
    "CreateConductorTicket",
    "CreateDeployRelease",
    "DeployRelease",
    "DocsSync",
    "ExportEmailsForOnboarding",
    "ExportFlashTop",
    "FirmwareToSt",
    "FurnitureFactory",
    "GroupMaintenance",
    "LogfellerUsageToSolomon",
    "LunaparkAutoshoot",
    "MakeAmmoBackend",
    "MakeQuasmodromGroups",
    "MaunaKeaScheduler",
    "MetricsToSensors",
    "NannyBackendRelease",
    "OtaToQuasmodrom",
    "Performance",
    "PgToYt",
    "Picklock",
    "PrCB",
    "PrCH",
    "ProductTask",
    "PublishOtaToS3",
    "PublishSpotterToS3",
    "PublishToS3",
    "PushToSolomon",
    "QloudRelease",
    "RegisterCalculation",
    "RegisterInReactor",
    "ReleaseAgeToSolomon",
    "ReleaseRmComponent",
    "ReleaseToNanny",
    "ReleaseToSamogon",
    "ReleaseToSandbox",
    "ReleaseToYaDeploy",
    "ReleaseWorkflow",
    "RemoteExec",
    "RestoreArcTables",
    "RunArcadiaTests",
    "RunCommand",
    "SandboxResourceCollector",
    "Sawmill",
    "SimpleReleaser",
    "Sum",
    "SumTask",
    "SummaryForYandexmini",
    "SyncCH",
    "UpdateCiRegistry",
    "UpdateDevicesInDb",
    "UpdateToQuasmodrom",
    "WaitForConductorTicket",
    "Woodcutter",
    "YaCommitTask",
]


def _ensure_py3():
    if sys.version_info.major == 2:
        dispatch.initialize_tasklet_registry()
        names = dispatch.list_tasklet_names()
        new_py2_tasklets = [_ for _ in names if _ not in PY2_TASKLETS_ALLOW_LIST]
        assert not new_py2_tasklets, \
            "New python2-tasklets detected: {}. Please migrate them to Python 3.".format(new_py2_tasklets)


_ensure_py3()
