from __future__ import unicode_literals

import base64
import json
import zlib

import six

import google.protobuf.descriptor_pb2 as proto_descr_pb2
from google.protobuf import json_format


def serialize_description(implementations, impl_cls, binary_meta=False):
    holder = impl_cls.__holder_cls__
    input_message = holder.Input
    output_message = holder.Output

    seen = set()
    fds = proto_descr_pb2.FileDescriptorSet()

    def _get_dependencies(fd):
        if fd.name in seen:
            return
        seen.add(fd.name)
        for d in fd.dependencies:
            _get_dependencies(d)
        fdp = fds.file.add()
        fd.CopyToProto(fdp)

    _get_dependencies(input_message.DESCRIPTOR.file)
    _get_dependencies(output_message.DESCRIPTOR.file)

    if binary_meta:
        description = six.ensure_text(base64.b64encode(zlib.compress(fds.SerializeToString(), 9)))
    else:
        description = json.loads(json_format.MessageToJson(fds))

    return json.dumps({
        "sbTask": impl_cls.__holder_cls__.sbtask_cls.name,
        "name": impl_cls.__holder_cls__.name,
        "input": input_message.DESCRIPTOR.full_name,
        "output": output_message.DESCRIPTOR.full_name,
        "meta": description,
        "implementations": implementations,
        "features": {
            "consumesSecretId": True
        }
    }, indent=4)
