import time
import logging
import functools

logger = logging.getLogger(__name__)


class BaseAdapter(object):

    def __init__(self, service):
        self._service = service


def call(method):

    @functools.wraps(method)
    def wrapper(*args, **kwargs):
        start = time.time()
        logger.debug("Call %s", method)
        try:
            return method(*args, **kwargs)
        finally:
            logger.debug("Finished call %s [%ss]", method, time.time() - start)

    return wrapper
