from tasklet.api import mem_pb2

from tasklet.domain.adapter import base


class Memory(base.BaseAdapter):

    def save(self, name, value):
        sm = mem_pb2.SaveMessage()
        sm.Key = name
        sm.Value.Pack(value)
        return self._service.Save(sm)

    def load(self, name, instance):
        ret = self._service.Load(mem_pb2.LoadMessage(Key=name))
        ret.Unpack(instance)
        return instance
