import time

from tasklet.domain.adapter import base


class Scheduler(base.BaseAdapter):

    def instance(self, job_desc):
        return self._service.Instance(job_desc)

    def schedule(self, job_instance):
        return self._service.Schedule(job_instance)

    def status(self, *refs):
        return self._service.GetStatus(iter(refs))

    def wait_for(self, *refs):
        # XXX really dummy impl

        refs = list(refs)
        while True:
            statuses = list(self.status(*refs))
            if all(s.ready for s in statuses):
                return statuses
            time.sleep(0.1)
