from google.protobuf import empty_pb2

from tasklet.api import spy_pb2

from tasklet.domain.adapter import base


class Spy(base.BaseAdapter):

    def whisper(self, id, state, run_id=None, name=None, parent=None, metadata=None):
        event = spy_pb2.Event(tasklet_id=id, state=state)
        if name is not None:
            event.tasklet_name = name
        if parent is not None:
            event.parent_id = parent
        if run_id is not None:
            event.run_id = run_id
        if metadata is not None:
            event.metadata = metadata
        return self._service.Whisper(event)

    def query(self):
        return self._service.Query(empty_pb2.Empty())
