from google.protobuf import empty_pb2

from tasklet.api import tasklet_pb2
from tasklet.api import executor_pb2
from tasklet.api import executor_pb2_grpc

from tasklet import runtime
from tasklet.runtime import dispatch


class LocalExecutor(executor_pb2_grpc.ExecutorServicer):
    def __init__(self):
        self.run_info = None

    def GetContext(self, request, context):
        return executor_pb2.ExecutorContext()

    def Inject(self, request, context):
        runtime.inject(request, self)

        return empty_pb2.Empty()

    def Execute(self, request, context):
        response_data = dispatch.dispatch(request.SerializeToString())
        res = tasklet_pb2.JobResult()
        res.ParseFromString(response_data)
        return res
