from google.protobuf import empty_pb2
from google.protobuf import any_pb2
from google.protobuf import json_format

from tasklet.api import mem_pb2
from tasklet.api import mem_pb2_grpc

from tasklet import runtime


class LocalMemory(mem_pb2_grpc.MemoryServicer):
    def __init__(self):
        self._storage = {}

    def GetContext(self, request, context):
        return mem_pb2.MemoryContext()

    def Inject(self, request, context):
        runtime.inject(request, self)

        return empty_pb2.Empty()

    def Save(self, request, context):
        self._storage[request.Key] = json_format.MessageToJson(request.Value)
        return empty_pb2.Empty()

    def Load(self, request, context):
        res = any_pb2.Any()
        if request.Key in self._storage:
            json_format.Parse(self._storage[request.Key], res)
        return res
