from google.protobuf import empty_pb2

from tasklet import runtime
from tasklet.api import spy_pb2
from tasklet.api import spy_pb2_grpc


class LocalSpy(spy_pb2_grpc.SpyServicer):
    def __init__(self):
        self._log = spy_pb2.SpyLog()

    def GetContext(self, request, context):
        return spy_pb2.SpyContext()

    def Inject(self, request, context):
        runtime.inject(request, self)

        return empty_pb2.Empty()

    def Query(self, request, context):
        return self._log

    def Whisper(self, request, context):
        self._log.events.extend([request])
        return empty_pb2.Empty()
