import getpass
import logging
import os

import library.python.oauth as lpo

from sandbox.common import rest
from sandbox import sdk2

CLIENT_ID = "43d6bd8a5d95465dabc0fa3136e7f74e"
CLIENT_SECRET = "064f39ba9e314212ad677d446a592212"

VAULT_NAME = "glycine_oauth_token"
YAV_SECRET_DEFAULT_KEY_NAME = "tasklet.token"

TOKEN_SCOPES = ["sandbox:api", "yt:api", "vault:use"]

logger = logging.getLogger(__name__)

token = os.environ.get("GLYCINE_TOKEN")
owner = os.environ.get("GLYCINE_SB_OWNER", getpass.getuser())


def url_to_get_token():
    return "https://oauth.yandex-team.ru/authorize?response_type=token&client_id={}&optional_scope={}".format(
        CLIENT_ID,
        " ".join(TOKEN_SCOPES),
    )


def get_token():
    if token:
        return token

    try:
        get_token.__res
    except AttributeError:
        get_token.__res = _calc_token()

    return get_token.__res


def _calc_token():
    # Sandbox
    if sdk2.Task.current:
        task = sdk2.Task.current
        secret = getattr(task.Parameters, "__tasklet_secret__", None)
        if secret:
            secret_data = secret.data()
            key = secret.default_key or YAV_SECRET_DEFAULT_KEY_NAME
            logger.debug("Using token from task parameters. Looking for key '%s' in secret %s.", key, secret)
            if key in secret_data:
                return secret_data[key]
            elif not secret.default_key and len(secret_data) == 1:
                key = next(secret_data.keys())
                logger.warning("Using secret with key `%s`", key)
                return secret_data[key]
            raise KeyError("There is no {} key in secret {}".format(key, secret))

        logger.debug("Getting token from Sandbox Vault")
        return sdk2.Vault.data(task.owner, VAULT_NAME)

    # YT
    yt_token = os.environ.get("YT_SECURE_VAULT_" + VAULT_NAME)
    if yt_token is not None:
        logger.debug("Got token from YT secure vault")
        return yt_token

    # Local
    env_token = os.environ.get("TASKLET_TOKEN")
    if env_token:
        logger.debug("Got token from TASKLET_TOKEN env variable")
        return env_token

    login = os.environ.get("USER")
    logger.debug("Getting token via OAuth as %s", login or "current user")
    return lpo.get_token(CLIENT_ID, CLIENT_SECRET, login=login)


def sandbox_client():
    if sdk2.Task.current is not None:
        return sdk2.Task.current.server
    return rest.Client(
        base_url="https://sandbox.yandex-team.ru/api/v1.0",
        auth=get_token(),
    )


def create_or_update_oauth_token():
    client = sandbox_client()

    items = client.vault[{
        "name": VAULT_NAME,
        "owner": owner
    }, : 1]["items"]

    data = {
        "name": VAULT_NAME,
        "owner": owner,
        "description": "Glycine OAuth token",
        "shared": [],
        "data": get_token(),
    }

    if items:
        assert len(items) == 1
        vault_id = items[0]["id"]
        logger.debug("Updating OAuth token for owner %s in Sandbox Vault %s", owner, vault_id)
        client.vault[vault_id] = data
    else:
        logger.debug("Creating OAuth token for owner %s in Sandbox Vault", owner)
        client.vault(data)
