from sandbox import sdk2
import sandbox.common.types.misc as ctm

from google.protobuf import empty_pb2
from google.protobuf import any_pb2
from google.protobuf import json_format

from tasklet.api import mem_pb2
from tasklet.api import mem_pb2_grpc

from tasklet import runtime


class SandboxInsideMemory(mem_pb2_grpc.MemoryServicer):
    def __init__(self):
        self._storage = {}

    def GetContext(self, request, context):
        return mem_pb2.MemoryContext()

    def Inject(self, request, context):
        runtime.inject(request, self)

        return empty_pb2.Empty()

    def Save(self, request, context):
        task = sdk2.Task.current
        setattr(task.Context, request.Key, json_format.MessageToJson(request.Value))

        return empty_pb2.Empty()

    def Load(self, request, context):
        task = sdk2.Task.current

        res = any_pb2.Any()

        val = getattr(task.Context, request.Key)
        if val != ctm.NotExists:
            json_format.Parse(val, res)

        return res
