import getpass
import logging
import os
import sys

from tasklet.domain import oauth

from sandbox import sdk2
from sandbox.common import hash as sb_hash
from sandbox.taskbox import binary as sb_binary

logger = logging.getLogger(__name__)


def tasks_binary_resource(
    owner, enable_taskbox,
    sandbox_url=None, sandbox_proxy_url=None, use_skynet=False, extra_attrs=None
):
    resource_id = os.environ.get('TASKLET_SANDBOX_ID')
    if resource_id is not None:
        logger.info('Using custom tasks resource %s', resource_id)
        return resource_id

    logger.info('Uploading tasks resource to Sandbox')

    token = oauth.get_token()
    if not token:
        raise Exception('Failed to get Sandbox OAuth token. Is there valid ssh-key in ssh-agent?')

    sb_auth = sb_binary.LazyAuth(token)
    sandbox = sb_binary.Sandbox(
        sandbox_url or sb_binary.Sandbox.BASE_URL,
        sandbox_proxy_url or sb_binary.Sandbox.BASE_PROXY_URL,
        sb_auth
    )
    uploader = sb_binary.CommandLineUploader(sandbox, logger)

    path = sys.argv[0]
    resource = uploader.upload(
        path,
        sdk2.service_resources.SandboxTasksBinary.name,
        'Tasks binary',
        owner or sandbox_owner(),
        sb_hash.md5sum(path),
        use_skynet=use_skynet,
        use_mds=True,
        extra_attrs=extra_attrs or {},
        force=False,
        enable_taskbox=enable_taskbox,
    )

    resource_id = resource['id']
    logger.info('Tasks resource has uploaded: %s', sandbox.resource_url(resource_id))
    return resource_id


def sandbox_owner():
    return os.environ.get('SANDBOX_OWNER', getpass.getuser())


def task_link(task_id):
    return sb_binary.Sandbox(sb_binary.Sandbox.BASE_URL, None, None).task_url(task_id)
