from tasklet.examples.crossplatform_interaction.proto import crossplatform_tasklet
from tasklet.examples.sum.proto import sum_tasklet


class CrossplatformInteractionImpl(crossplatform_tasklet.CrossplatformCheckBase):

    def run(self):
        py_tasklet = sum_tasklet.Sum(self.ctx.ctx_msg, sum_tasklet.Sum.Input(num1=self.input.num1, num2=self.input.num2))
        py_tasklet.name = "SumPy"
        self.output.py_out = self.wait("sum tasklet python", py_tasklet).sum_value

        cpp_tasklet = sum_tasklet.Sum(self.ctx.ctx_msg, sum_tasklet.Sum.Input(num1=self.input.num1, num2=self.input.num2))
        cpp_tasklet.name = "SumCpp"
        self.output.cpp_out = self.wait("sum tasklet cpp", cpp_tasklet).sum_value

        self.output.out = "C++ and Python tasklets have {} output".format(
            "the same" if self.output.py_out == self.output.cpp_out else "different"
        )
