from tasklet.examples.local_services.proto import local_services_tasklet
from tasklet.examples.local_services.proto import local_services_pb2


class SeviceUsageImpl(local_services_tasklet.ServicesTestBase):
    def run(self):
        mem_message = local_services_pb2.Msg()
        mem_message.msg = self.input.mem_test_message

        self.ctx.mem.save('test', mem_message)

        mem_output = local_services_pb2.Msg()
        self.ctx.mem.load('test', mem_output)
        self.output.msg_test.CopyFrom(mem_output)

        self.ctx.spy.whisper(self.tasklet_id, self.input.spy_test_state)
        self.output.spy_test.msg = "spy message wasn't found"
        for event in self.ctx.spy.query().events:
            if event.tasklet_id == self.tasklet_id and event.state == self.input.spy_test_state:
                self.output.spy_test.msg = 'spy message was found'
                break
