import logging

from tasklet.examples.secrets.proto import secrets_tasklet


class SecretsExampleImpl(secrets_tasklet.SecretsExampleBase):
    def run(self):
        secret = self.ctx.yav.get_secret(self.input).secret

        logging.info(
            "Got secret value by key '%s' from secret '%s'. Length: %s",
            self.input.key, self.input.uuid, len(secret),
        )

        self.output.length = len(secret)
