import dataclasses
import enum
from typing import Optional, List


# Tasklets CLI application owned by 'robot-tasklets'
# Permissions: tasklets:use, sandbox:api
CLIENT_ID = "aa711fdbe7e942c7b68f07375c1171a4"
CLIENT_SECRET = "a756b3fb12f84d04a8875c36691a4eb2"

SANDBOX_URL = "https://sandbox.yandex-team.ru"
SANDBOX_PROXY_URL = "http://proxy.sandbox.yandex-team.ru"
DEFAULT_RESOURCE_TYPE = "TASKLET_EXECUTABLE"

TASKLET_ENDPOINT_ENV_VAR = "TASKLET_ENDPOINT"


@dataclasses.dataclass
class ClusterConfig:
    name: str
    endpoint: Optional[str] = None
    endpoint_set_id: Optional[str] = None
    clusters: List[str] = None


LOCAL = ClusterConfig("local", endpoint="localhost:6666")
ENV = ClusterConfig("env", endpoint="")
TEST = ClusterConfig("test", endpoint_set_id="tasklets-testing.api-server.grpc", clusters=["sas", "iva"])
PROD = ClusterConfig("prod", endpoint_set_id="tasklets-production.api-server.grpc", clusters=["sas", "iva", "vla"])
UNITTEST = ClusterConfig("unittest")

CLUSTER_CONFIGS = {
    LOCAL.name: LOCAL,
    ENV.name: ENV,
    TEST.name: TEST,
    PROD.name: PROD,
}


class Output(str, enum.Enum):
    JSON = "json"
    YAML = "yaml"
    TABLE = "table"


ALL_OUTPUT_FORMATS = (Output.JSON, Output.YAML, Output.TABLE)


class ProtoFormat(str, enum.Enum):
    PROTO_JSON = "json"
    PROTO_BINARY = "binary"
    PROTO_TEXT = "text"
