import importlib.util
import time

import sys
import types
import logging


log = logging.getLogger(__name__)


def import_module(name: str) -> types.ModuleType:
    ts = time.time()
    spec = importlib.util.find_spec(name)
    loader = importlib.util.LazyLoader(spec.loader)
    spec.loader = loader
    module = importlib.util.module_from_spec(spec)
    sys.modules[name] = module
    loader.exec_module(module)
    log.debug(f"Lazy imported module {name}. Duration: {time.time() - ts}")
    return module
