# coding=utf-8
import json

import pytest
from click.testing import CliRunner

from tasklet.experimental.cli import cmd_execution
from tasklet.experimental.cli import consts
from tasklet.experimental.tests.common import models
from tasklet.experimental.tests.common import server_mock
from tasklet.api.v2 import well_known_structures_pb2


@pytest.mark.usefixtures("tasklet_context")
@pytest.mark.parametrize("output_format", consts.ALL_OUTPUT_FORMATS)
def test_execution_list(
    tasklet_server: server_mock.TaskletServer,
    simple_test_tasklet: models.Tasklet,
    registered_schema: str,
    output_format: str
):
    payload = well_known_structures_pb2.GenericBinary(payload=b"test")
    builds = (12345, "foo_label", 2), (54321, "bar_label", 1)
    build_ids, execution_ids = [], []
    for resource_id, label_name, repeat in builds:
        build = tasklet_server.create_build(
            simple_test_tasklet, registered_schema, dict(payload=dict(sandbox_resource_id=resource_id))
        )
        build_ids.append(build.ID)
        label = tasklet_server.create_label(simple_test_tasklet, label_name, build, None)
        for _ in range(repeat):
            execution_id = tasklet_server.create_execution(simple_test_tasklet, label, payload)
            execution_ids.append(execution_id)
    runner = CliRunner()
    result = runner.invoke(
        cmd_execution.execution_subcommand,
        ["list", "-o", output_format, f"{simple_test_tasklet.NS}/{simple_test_tasklet.Name}"],
    )
    assert result.exit_code == 0
    for build_id in build_ids:
        assert build_id in result.output
    for execution_id in execution_ids:
        assert execution_id in result.output
    if output_format == consts.Output.JSON:
        data = json.loads(result.output)
        assert len(data["executions"]) == 3
    result = runner.invoke(
        cmd_execution.execution_subcommand,
        ["list", "-o", output_format, f"{simple_test_tasklet.NS}/{simple_test_tasklet.Name}", "-l", 2],
    )
    assert result.exit_code == 0
    if output_format == consts.Output.JSON:
        data = json.loads(result.output)
        assert len(data["executions"]) == 2
    result = runner.invoke(
        cmd_execution.execution_subcommand,
        ["list", "-o", output_format, f"{simple_test_tasklet.NS}/{simple_test_tasklet.Name}:{build_ids[0]}"],
    )
    assert result.exit_code == 0
    assert build_ids[0] in result.output
    assert build_ids[1] not in result.output
    assert execution_ids[0] in result.output
    assert execution_ids[1] in result.output
    assert execution_ids[2] not in result.output
    if output_format == consts.Output.JSON:
        data = json.loads(result.output)
        assert len(data["executions"]) == 2
    result = runner.invoke(
        cmd_execution.execution_subcommand,
        ["list", "-o", output_format, f"{simple_test_tasklet.NS}/{simple_test_tasklet.Name}:{build_ids[0]}", "-l", 1],
    )
    assert result.exit_code == 0
    if output_format == consts.Output.JSON:
        data = json.loads(result.output)
        assert len(data["executions"]) == 1


@pytest.mark.usefixtures("tasklet_context")
@pytest.mark.parametrize("output_format", consts.ALL_OUTPUT_FORMATS)
def test_execution_get(
    tasklet_server: server_mock.TaskletServer,
    simple_test_tasklet: models.Tasklet,
    registered_schema: str,
    output_format: str
):
    label_name = "foo_label"
    payload = well_known_structures_pb2.GenericBinary(payload=b"test")
    build = tasklet_server.create_build(simple_test_tasklet, registered_schema, None)
    label = tasklet_server.create_label(simple_test_tasklet, label_name, build, None)
    execution_id = tasklet_server.create_execution(simple_test_tasklet, label, payload)
    runner = CliRunner()
    result = runner.invoke(
        cmd_execution.execution_subcommand,
        ["get", "-o", output_format, execution_id],
    )
    assert result.exit_code == 0
    assert build.ID in result.output
    assert label.Name in result.output
