# coding=utf-8
import json

import pytest
from click.testing import CliRunner

from tasklet.experimental.cli import cmd_namespace
from tasklet.experimental.cli import consts
from tasklet.experimental.tests.common import models
from tasklet.experimental.tests.common import server_mock


@pytest.mark.usefixtures("tasklet_context")
@pytest.mark.parametrize("output_format", consts.ALL_OUTPUT_FORMATS)
def test_namespace_create(output_format: str):
    namespace_name, owner = "foo_namespace", "abc:foo"
    runner = CliRunner()
    result = runner.invoke(
        cmd_namespace.namespace_subcommand,
        ["create", "-o", output_format, namespace_name, "--owner", owner],
    )
    assert result.exit_code == 0
    assert namespace_name in result.output
    assert owner in result.output


@pytest.mark.usefixtures("tasklet_context")
@pytest.mark.parametrize("output_format", consts.ALL_OUTPUT_FORMATS)
def test_namespace_list(tasklet_server: server_mock.TaskletServer, output_format: str):
    namespaces = ("foo_ns", "bar_ns")
    owner = "abc:foo"
    for namespace_name in namespaces:
        tasklet_server.create_ns(namespace_name, owner)
    runner = CliRunner()
    result = runner.invoke(
        cmd_namespace.namespace_subcommand,
        ["list", "-o", output_format],
    )
    assert result.exit_code == 0
    for namespace in namespaces:
        assert namespace in result.output
    assert owner in result.output
    if output_format == consts.Output.JSON:
        data = json.loads(result.output)
        assert len(data["namespaces"]) == 2


@pytest.mark.usefixtures("tasklet_context")
@pytest.mark.parametrize("output_format", consts.ALL_OUTPUT_FORMATS)
def test_namespace_get(
    simple_test_tasklet: models.Tasklet,
    output_format: str
):
    runner = CliRunner()
    # NB: namespace get also dumps list of tasklets in namespace
    result = runner.invoke(
        cmd_namespace.namespace_subcommand,
        ["get", "-o", output_format, simple_test_tasklet.NS],
    )
    assert result.exit_code == 0
    assert simple_test_tasklet.NS in result.output
    if output_format == consts.Output.TABLE:
        assert simple_test_tasklet.Name in result.output
