# coding=utf-8
import os

import pytest
from click import testing as click_testing

from yatest import common as yatest

from tasklet.experimental.cli import cmd_sr
from tasklet.experimental.cli import consts


@pytest.mark.usefixtures("tasklet_context")
@pytest.mark.parametrize("output_format", consts.ALL_OUTPUT_FORMATS)
def test_sr_put_table(output_format: str):
    schemas = yatest.binary_path("tasklet/registry/common/tasklet-registry-common.protodesc")
    runner = click_testing.CliRunner()
    result = runner.invoke(
        cmd_sr.schema_registry_subcommand,
        ["put", "-o", output_format, schemas, "-a", '{"foo": "bar_test_grep_me", "baz": [1, 2, 3]}'],
    )

    if output_format == consts.Output.TABLE:
        assert "Schema created" in result.output
    else:
        assert "Schema created" not in result.output
    assert "bar_test_grep_me" in result.output
    assert result.exit_code == 0


@pytest.mark.usefixtures("tasklet_context")
def test_sr_get(registered_schema: str):
    out_root = yatest.test_output_path("sg_get")
    os.mkdir(out_root)
    output_path = os.path.join(out_root, "dumped.protodesc")

    runner = click_testing.CliRunner()
    result = runner.invoke(
        cmd_sr.schema_registry_subcommand,
        ["get", "-o", "table", registered_schema, output_path],
    )

    assert "Meta:" in result.output
    assert "Annotations:" in result.output
    assert result.exit_code == 0
    assert os.path.isfile(output_path)

    from google.protobuf import descriptor_pb2

    fds = descriptor_pb2.FileDescriptorSet()
    with open(output_path, "rb") as f:
        fds.ParseFromString(f.read())

    assert len(fds.file) > 0
