package main

import (
	"log"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/tasklet/experimental/internal/apiclient"
	"a.yandex-team.ru/tasklet/experimental/internal/executor"
)

var args = executor.Args{
	Config: &apiclient.Config{},
}

var deprecatedTokenPath string
var disableAuth bool

func runCmdHandler(_ *cobra.Command, _ []string) error {
	args.Config.EnableAuth = !disableAuth
	return executor.Main(args)
}

func main() {
	var command = &cobra.Command{
		Use:   "tasklet-executor",
		Short: "Tasklet executor",
		Long: "Tasklet executor does the following:\n" +
			"1) creates environment for executed tasklet;\n" +
			"2) provides local gRPC-service from tasklets/experimental/tasklet_api/executor;\n" +
			"3) runs subprocess with tasklet and waits for its finish;\n" +
			"4) reports tasklet status and result to Tasklets service.\n\n" +
			"If `tasklet-path` is not provided, then executor doesn't run subprocess. " +
			"This run mode could be used for the testing purpose.",
		RunE: runCmdHandler,
	}

	command.Flags().StringVar(&args.ExecutionID, "execution-id", "", "tasklet launch id")
	command.Flags().StringVar(&deprecatedTokenPath, "token-path", "", "deprecated")
	command.Flags().StringVar(
		&args.TaskletPath,
		"tasklet-path",
		"",
		"path to binary that implements tasklet",
	)
	command.Flags().StringVar(&args.LogsDir, "logs-dir", ".", "(unused) directory for logs")
	command.Flags().StringVar(
		&args.Config.EndpointSetName,
		"endpoint-set",
		"",
		"endpoint set name of tasklet grpc service",
	)
	command.Flags().StringVar(
		&args.Config.EndpointAddress,
		"endpoint-address",
		"",
		"address of tasklet grpc service",
	)
	command.Flags().BoolVar(&disableAuth, "disable-auth", false, "disable auth (for testing)")

	// FIXME: delete JavaBinary
	command.Flags().StringVar(&args.JavaBinary, "java-binary", "", "path to java binary")

	for _, varName := range []string{"execution-id", "tasklet-path"} {
		if err := command.MarkFlagRequired(varName); err != nil {
			log.Fatalf("%+v\n", err)
		}
	}

	if err := command.Execute(); err != nil {
		log.Fatalf("%+v\n", err)
	}
}
