package configs

import (
	"testing"

	"github.com/stretchr/testify/require"

	"a.yandex-team.ru/library/go/test/canon"
)

func TestProdIdmConfigCanon(t *testing.T) {
	conf, err := NewIdmConfig("production-stage")
	require.NoError(t, err)
	require.NoError(t, conf.Validate())
	canon.SaveJSON(t, conf)
}

func TestTestingIdmConfigCanon(t *testing.T) {
	conf, err := NewIdmConfig("testing-stage")
	require.NoError(t, err)
	require.NoError(t, conf.Validate())
	canon.SaveJSON(t, conf)
}
