package main

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"

	"go.uber.org/zap/zapcore"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/core/metrics/solomon"
)

func main() {
	// NB: tiny go playgroud
	logConf := zap.ConsoleConfig(log.DebugLevel)
	logConf.EncoderConfig.EncodeLevel = zapcore.CapitalColorLevelEncoder
	logger := zap.Must(logConf)
	logger.Info("Hi!")
	ctx, cancel := context.WithCancel(context.Background())
	defer cancel()
	mr := solomon.NewRegistry(solomon.NewRegistryOpts())

	defer func() {
		buf := &bytes.Buffer{}
		if _, err := mr.StreamJSON(ctx, buf); err != nil {
			panic(err)
		}
		var z any
		if err := json.Unmarshal(buf.Bytes(), &z); err != nil {
			panic(err)
		}
		out, err := json.MarshalIndent(z, "", " ")
		if err != nil {
			panic(err)
		}
		fmt.Println(string(out))
	}()
}
