package configs

import (
	"testing"

	"github.com/stretchr/testify/require"

	"a.yandex-team.ru/library/go/test/canon"
)

func TestGetConfig(t *testing.T) {
	embeddedConfigs := ListEmbedded()
	require.NotEmpty(t, embeddedConfigs)
	require.Contains(t, embeddedConfigs, DefaultEmbeddedConfig)

	for _, baseConfName := range embeddedConfigs {
		v, err := New(baseConfName, "")
		require.NoError(t, err)
		require.NotEmpty(t, v)
		require.NoError(t, v.Validate())
	}
}

func TestProdConfigCanon(t *testing.T) {
	conf, err := New("production-stage", "")
	require.NoError(t, err)
	require.NoError(t, conf.Validate())
	canon.SaveJSON(t, conf)
}

func TestTestingConfigCanon(t *testing.T) {
	conf, err := New("testing-stage", "")
	require.NoError(t, err)
	require.NoError(t, conf.Validate())
	canon.SaveJSON(t, conf)
}
