package configs

import (
	"embed"
	"strings"
)

const (
	embeddedConfigsSuffix = ".yaml"
)

//go:embed *.yaml
var embeddedFS embed.FS

func GetConfig(name string) ([]byte, error) {
	fullName := name + embeddedConfigsSuffix

	return embeddedFS.ReadFile(fullName)
}

// ListConfigs returns list of available embedded configs
func ListConfigs() []string {
	var embedded []string
	items, _ := embeddedFS.ReadDir(".")
	for _, item := range items {
		if !item.IsDir() && strings.HasSuffix(item.Name(), embeddedConfigsSuffix) {
			embedded = append(embedded, strings.TrimSuffix(item.Name(), embeddedConfigsSuffix))
		}
	}
	return embedded
}
