package main

import (
	"fmt"
	"log"
	"os"
	"time"

	taskletexamples "a.yandex-team.ru/tasklet/experimental/examples/proto"
	sdk "a.yandex-team.ru/tasklet/experimental/sdk/go/dummy"
)

func main() {
	_, inputFile, outputFile, errorFile := os.Args[1], os.Args[2], os.Args[3], os.Args[4]

	input := &taskletexamples.ErrorGeneratorInput{}
	if err := sdk.ReadInput(input, inputFile); err != nil {
		log.Fatalf("Failed to read input: %v", err)
	}

	switch command := input.Command.(type) {
	case *taskletexamples.ErrorGeneratorInput_Crash:
		c := command.Crash
		if _, err := os.Stdout.WriteString(c.OutString); err != nil {
			panic(err)
		}
		if _, err := os.Stderr.WriteString(c.ErrString); err != nil {
			panic(err)
		}
		os.Exit(int(command.Crash.ExitCode))
	case *taskletexamples.ErrorGeneratorInput_Timeout:
		c := command.Timeout
		if _, err := os.Stdout.WriteString(c.OutString); err != nil {
			panic(err)
		}
		if _, err := os.Stderr.WriteString(c.ErrString); err != nil {
			panic(err)
		}
		<-time.After(time.Second * time.Duration(c.Duration))
		panic("after sleep")
	case *taskletexamples.ErrorGeneratorInput_UserError:
		c := command.UserError
		if _, err := os.Stdout.WriteString(c.OutString); err != nil {
			panic(err)
		}
		if _, err := os.Stderr.WriteString(c.ErrString); err != nil {
			panic(err)
		}
		if err := sdk.WriteOutput(c.Error, errorFile); err != nil {
			panic(err)
		}
		os.Exit(int(c.ExitCode))
	case *taskletexamples.ErrorGeneratorInput_Ok:
		c := command.Ok
		if err := sdk.WriteOutput(c.Output, outputFile); err != nil {
			panic(err)
		}
	default:
		panic(fmt.Sprintf("Unexpected command: %T", command))

	}
}
