#!/usr/bin/env python3
import os
import subprocess
import sys

from tasklet.api.v2 import context_pb2
from tasklet.api.v2 import executor_service_pb2
from tasklet.api.v2 import executor_service_pb2_grpc

from tasklet.experimental.examples.proto import fake_ya_make_pb2
from tasklet.experimental.sdk.py.dummy import interface as dummy_sdk


def main():
    tasklet_io = dummy_sdk.TaskletInterface()

    request = tasklet_io.read_input(fake_ya_make_pb2.FakeYaMakeInput())
    client: executor_service_pb2_grpc.ExecutorServiceStub = tasklet_io.executor_client
    context: context_pb2.Context = client.GetContext(executor_service_pb2.GetContextRequest()).context

    arc_token_ref = request.arc_token
    resp: executor_service_pb2.GetSecretRefResponse = client.GetSecretRef(
        executor_service_pb2.GetSecretRefRequest(ref=arc_token_ref)
    )
    arc_token = resp.value.value

    os.makedirs("store")
    os.makedirs("arc")
    env = os.environ.copy()
    env["ARC_TOKEN"] = arc_token
    p = subprocess.Popen(
        [
            context.environment.arc_client.path,
            "mount",
            "-S", "store",
            "-m", "arc",
            "--no-ssh-tokens",
        ],
        env=env,
        stdout=sys.stdout,
        stderr=sys.stderr,
    )
    p.wait()
    if p.returncode != 0:
        raise RuntimeError(f"arc mount rc: {p.returncode} != 0")

    try:
        subprocess.Popen(["ls", "arc"], stdout=sys.stdout, stderr=sys.stderr)
        print(f"SPAWN: ya make --branch {request.branch} --revision {request.revision}")
    finally:
        pp = subprocess.Popen(
            [
                context.environment.arc_client.path,
                "unmount",
                "arc",
                "--forget",
            ],
            env=env,
            stdout=sys.stdout,
            stderr=sys.stderr,
        )
        pp.wait()
        print(f"UMOUNT RC: {pp.returncode}", file=sys.stderr)

    output = fake_ya_make_pb2.FakeYaMakeOutput()
    output.resource_output.append(
        fake_ya_make_pb2.SandboxResource(
            name="basesearch",
            resource_id=1297834897,
        )
    )

    tasklet_io.write_output(output)


if __name__ == "__main__":
    main()
