from tasklet.api.v2 import executor_service_pb2
from tasklet.api.v2 import executor_service_pb2_grpc

from tasklet.experimental.examples.proto import secrets_handler_pb2
from tasklet.experimental.sdk.py.dummy import interface as dummy_sdk


def main():
    tasklet_io = dummy_sdk.TaskletInterface()

    executor_service: executor_service_pb2_grpc.ExecutorServiceStub = tasklet_io.executor_client
    request: secrets_handler_pb2.SecretsHandlerInput = tasklet_io.read_input(
        secrets_handler_pb2.SecretsHandlerInput(),
    )

    resp: executor_service_pb2.GetSecretRefResponse = executor_service.GetSecretRef(
        executor_service_pb2.GetSecretRefRequest(ref=request.my_token)
    )

    token_hash = hash(resp.value.value[:5])

    output = secrets_handler_pb2.SecretsHandlerOutput(secret_hash=str(token_hash))

    tasklet_io.write_output(output)


if __name__ == "__main__":
    main()
