#!/usr/bin/env python3
import json

import yaml

from tasklet.experimental.examples.proto import yaml_to_json_pb2
from tasklet.experimental.sdk.py.dummy import interface as dummy_sdk


def main():
    tasklet_io = dummy_sdk.TaskletInterface()
    request: yaml_to_json_pb2.YamlToJsonInput = tasklet_io.read_input(yaml_to_json_pb2.YamlToJsonInput())

    data = yaml.safe_load(request.input)

    response = yaml_to_json_pb2.YamlToJsonOutput()
    response.output = json.dumps(data).encode()

    tasklet_io.write_output(response)


if __name__ == "__main__":
    main()
