package access

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/ctxlog"
	"a.yandex-team.ru/library/go/core/xerrors"
	acmodel "a.yandex-team.ru/tasklet/experimental/internal/access/model"
	"a.yandex-team.ru/tasklet/experimental/internal/consts"
	"a.yandex-team.ru/tasklet/experimental/internal/yandex/staff"
)

type PermissionsChecker struct {
	logger     log.Logger
	staffCache *staff.StaffGroupsCache
}

func NewAccessChecker(staffCache *staff.StaffGroupsCache, logger log.Logger) *PermissionsChecker {
	return &PermissionsChecker{
		logger:     logger,
		staffCache: staffCache,
	}
}

func (pc *PermissionsChecker) CheckCommonPermission(
	ctx context.Context, user string, action acmodel.BaseAccessMaskType, permissions consts.Permissions,
) (bool, error) {
	groupsMap, err := pc.staffCache.ListUserGroups(ctx, user)
	if err != nil {
		return false, err
	}
	mask := acmodel.RoleMaskType(0)
	for _, ps := range permissions {
		if ps.Name != user && !groupsMap[ps.Name] {
			continue
		}
		for _, role := range ps.Roles {
			mask |= acmodel.RoleTypesMap[acmodel.RoleType(role)]
		}
	}

	if int64(action)&int64(mask) > 0 {
		return true, nil
	} else {
		return false, nil
	}
}

func (pc *PermissionsChecker) CheckPermissions(
	ctx context.Context, user string, action acmodel.BaseAccessMaskType, data *acmodel.AccessData,
) error {
	ok, err := pc.CheckCommonPermission(ctx, user, action, data.GetPermissions())
	if err != nil {
		ctxlog.Errorf(
			ctx,
			pc.logger,
			"Error on checking permissions. Login: %v, actions: %v, error: %+v",
			user,
			action,
			err,
		)
		return err
	}
	if !ok {
		return xerrors.New("Access denied.")
	}
	return nil
}
