package model

type BaseAccessMaskType int64

const (
	BaseNamespaceRead  BaseAccessMaskType = 0x00000001
	BaseCreateTasklet  BaseAccessMaskType = 0x00000002
	BaseNamespaceOwner BaseAccessMaskType = 0x00000004
	BaseTaskletRead    BaseAccessMaskType = 0x00000008
	BaseTaskletWrite   BaseAccessMaskType = 0x00000010
	BaseTaskletRun     BaseAccessMaskType = 0x00000020
	BaseTaskletOwner   BaseAccessMaskType = 0x00000040
)

type RoleMaskType int64

const (
	NamespaceReadMask  = RoleMaskType(BaseNamespaceRead | BaseTaskletRead)
	CreateTaskletMask  = RoleMaskType(BaseNamespaceRead | BaseCreateTasklet | BaseTaskletRead)
	NamespaceOwnerMask = RoleMaskType(BaseNamespaceRead | BaseCreateTasklet | BaseNamespaceOwner | BaseTaskletRead)
	TaskletReadMask    = RoleMaskType(BaseTaskletRead)
	TaskletWriteMask   = RoleMaskType(BaseTaskletRead | BaseTaskletWrite)
	TaskletRunMask     = RoleMaskType(BaseTaskletRead | BaseTaskletRun)
	TaskletOwnerMask   = RoleMaskType(BaseTaskletRead | BaseTaskletWrite | BaseTaskletRun | BaseTaskletOwner)
)

type RoleType string

const (
	NamespaceRead  RoleType = "NamespaceRead"
	CreateTasklet  RoleType = "CreateTasklet"
	NamespaceOwner RoleType = "NamespaceOwner"
	TaskletRead    RoleType = "TaskletRead"
	TaskletWrite   RoleType = "TaskletWrite"
	TaskletRun     RoleType = "TaskletRun"
	TaskletOwner   RoleType = "TaskletOwner"
)

var RoleTypesMap = map[RoleType]RoleMaskType{
	NamespaceRead:  NamespaceReadMask,
	CreateTasklet:  CreateTaskletMask,
	NamespaceOwner: NamespaceOwnerMask,
	TaskletRead:    TaskletReadMask,
	TaskletWrite:   TaskletWriteMask,
	TaskletRun:     TaskletRunMask,
	TaskletOwner:   TaskletOwnerMask,
}
