package model

import (
	"fmt"

	taskletv2 "a.yandex-team.ru/tasklet/api/v2"
	"a.yandex-team.ru/tasklet/experimental/internal/consts"

	"golang.org/x/xerrors"
)

type AccessData struct {
	Namespace *taskletv2.Namespace
	Tasklet   *taskletv2.Tasklet
}

func (as *AccessData) GetPermissions() consts.Permissions {
	var permissions consts.Permissions
	for _, ps := range as.Namespace.GetMeta().GetPermissions().GetSubjects() {
		permissions = append(permissions, ps)
	}
	for _, ps := range as.Tasklet.GetMeta().GetPermissions().GetSubjects() {
		permissions = append(permissions, ps)
	}
	return permissions
}

func GetPermissionsSubject(
	name string,
	source taskletv2.PermissionsSubject_ESource,
	permissions *taskletv2.Permissions,
) *taskletv2.PermissionsSubject {
	var permissionSubject *taskletv2.PermissionsSubject
	for _, ps := range permissions.Subjects {
		if ps.Source == source && ps.Name == name {
			permissionSubject = ps
			break
		}
	}
	return permissionSubject
}

func GetRoleIdx(role RoleType, permissionsSubject *taskletv2.PermissionsSubject) (int, error) {
	sr := string(role)
	for idx, r := range permissionsSubject.Roles {
		if r == sr {
			return idx, nil
		}
	}
	return 0, xerrors.New(fmt.Sprintf("Not found role %s", role))
}

type RoleOperation = func(
	role RoleType,
	name string,
	source taskletv2.PermissionsSubject_ESource,
	permissions **taskletv2.Permissions,
) error

func checkNilPermissions(permissions **taskletv2.Permissions) {
	if *permissions == nil {
		*permissions = &taskletv2.Permissions{}
	}
}

func AddRole(
	role RoleType,
	name string,
	source taskletv2.PermissionsSubject_ESource,
	permissions **taskletv2.Permissions,
) error {
	checkNilPermissions(permissions)
	ps := *permissions

	if _, ok := RoleTypesMap[role]; !ok {
		return xerrors.New(fmt.Sprintf("Unknown role %s", role))
	}
	permissionSubject := GetPermissionsSubject(name, source, ps)

	if permissionSubject == nil {
		ps.Subjects = append(
			ps.Subjects, &taskletv2.PermissionsSubject{
				Source: source,
				Name:   name,
				Roles:  []string{string(role)},
			},
		)
	} else {
		if _, idx := GetRoleIdx(role, permissionSubject); idx != nil {
			permissionSubject.Roles = append(permissionSubject.Roles, string(role))
		}
	}
	return nil
}

func RemoveRole(
	role RoleType,
	name string,
	source taskletv2.PermissionsSubject_ESource,
	permissions **taskletv2.Permissions,
) error {
	checkNilPermissions(permissions)
	ps := *permissions
	permissionsSubject := GetPermissionsSubject(name, source, ps)

	if permissionsSubject == nil {
		return nil
	} else {
		roleIdx, err := GetRoleIdx(role, permissionsSubject)
		if err != nil {
			return nil
		}
		permissionsSubject.Roles[roleIdx] = permissionsSubject.Roles[len(permissionsSubject.Roles)-1]
		permissionsSubject.Roles = permissionsSubject.Roles[:len(permissionsSubject.Roles)-1]
	}
	return nil
}
