package apiclient

import (
	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/library/go/valid"
)

type Config struct {
	EndpointAddress string `yaml:"endpoint_address"`
	EndpointSetName string `yaml:"endpoint_set_name"`
	EnableAuth      bool   `yaml:"enable_auth"`
}

func (c *Config) Validate(_ *valid.ValidationCtx) (bool, error) {
	if (c.EndpointSetName == "") == (c.EndpointAddress == "") {
		return false, valid.ErrValidation.Wrap(
			xerrors.Errorf("Exactly one of endpoint_set_name and endpoint_address required"),
		)
	}
	return true, nil
}
