package apiserver

type MiddlewareConf struct {
	Auth             bool `yaml:"auth"`
	LogRequests      bool `yaml:"log_requests"`       // FIXME: use %q in grpc middleware before production
	LogRequestsFancy bool `yaml:"log_requests_fancy"` // NB: breaks logging!
}

type Config struct {
	Host        string          `yaml:"host"`
	Port        int             `yaml:"port" valid:"greater=0"`
	EnableTLS   bool            `yaml:"enable_ssl"`
	CertFile    string          `yaml:"cert_file"`
	KeyFile     string          `yaml:"key_file"`
	ExposeError bool            `yaml:"expose_error"`
	Middleware  *MiddlewareConf `yaml:"middleware"`
}
