package cli

import (
	"bufio"
	"fmt"
	"os"
	"strings"

	"golang.org/x/exp/slices"

	"a.yandex-team.ru/library/go/core/log"
)

var yes = []string{"y", "yes"}

func AskForConfirmation(s string, logger log.Logger) bool {
	reader := bufio.NewReader(os.Stdin)
	fmt.Printf("%s [y/N]: ", s)
	response, err := reader.ReadString('\n')
	if err != nil {
		logger.Error(err.Error())
		os.Exit(0)
	}

	response = strings.ToLower(strings.TrimSpace(response))
	return slices.Contains(yes, strings.ToLower(response))
}
