package server

import (
	"fmt"
	"log"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/maxprocs"
	"a.yandex-team.ru/tasklet/experimental/cmd/server/configs"
)

var (
	configFilePath string
	baseConfigName string
	conf           *configs.Config
)

func initConfig() (err error) {
	log.Printf("Initialize %q config using file %q", baseConfigName, configFilePath)
	if conf, err = configs.New(baseConfigName, configFilePath); err != nil {
		return err
	}
	return nil
}

func validateConfig(_ *cobra.Command, _ []string) error {
	return conf.Validate()
}

func rootCmdHandler(_ *cobra.Command, _ []string) error {
	if err := initConfig(); err != nil {
		return err
	}
	maxprocs.AdjustAuto()
	return nil
}

var rootCmd = &cobra.Command{
	Use:               "tasklet-server",
	Short:             "Tasklet server",
	PersistentPreRunE: rootCmdHandler,
}

func Execute() {
	if err := rootCmd.Execute(); err != nil {
		log.Fatal(err)
	}
}

func init() {
	rootCmd.PersistentFlags().StringVarP(
		&configFilePath,
		"config-path",
		"c",
		"",
		"path to config; it is used as patch for base config",
	)
	rootCmd.PersistentFlags().StringVarP(
		&baseConfigName,
		"base-config",
		"b",
		configs.DefaultEmbeddedConfig,
		fmt.Sprintf("name of base embedded config; values: %v", configs.ListEmbedded()),
	)
	rootCmd.AddCommand(serverCmd)
	rootCmd.AddCommand(storageCmd)
	rootCmd.AddCommand(configCmd)
	rootCmd.AddCommand(ytRunCmd)
}
