package migrations

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/tasklet/experimental/internal/cmd/server/migrations/v2"
	"a.yandex-team.ru/tasklet/experimental/internal/cmd/server/migrations/v3"
	"a.yandex-team.ru/tasklet/experimental/internal/ydbmigrate"
)

var Migrations = map[ydbmigrate.SchemaVersion]*ydbmigrate.Migration{
	1: &v2.MigrateV1V2,
	2: &v3.MigrateV2V3,
}

func init() {
	for _, migration := range Migrations {
		if len(migration.Mutations) == 0 {
			panic(fmt.Sprintf("0 len mutations for v%d", migration.BaseVersion))
		}
		for i, m := range migration.Mutations {
			prefix := fmt.Sprintf("%0.4d_", i)
			if !strings.HasPrefix(m.MutationName, prefix) {
				panic(fmt.Sprintf("Bad mutation name prefix. Expected: %q, Actual: %q", prefix, m.MutationName))
			}
		}
	}
}
