package shared

import (
	"encoding/json"

	"github.com/google/go-cmp/cmp"
)

func MustDiffJSON(b0, b1 []byte) string {

	rv, err := DiffJSON(b0, b1)
	if err != nil {
		panic(err)
	}
	return rv
}

func DiffJSON(b0, b1 []byte) (string, error) {
	// NB: https://github.com/google/go-cmp/issues/224
	var v1 any
	var v0 any
	if err := json.Unmarshal(b1, &v1); err != nil {
		return "", err
	}
	if err := json.Unmarshal(b0, &v0); err != nil {
		return "", err
	}

	diff := cmp.Diff(v0, v1)
	return diff, nil
}
