package wrench

import (
	"gopkg.in/yaml.v2"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/library/go/valid"
	"a.yandex-team.ru/tasklet/experimental/internal/apiclient"
)

type Config struct {
	API *apiclient.Config
}

func (conf *Config) Validate() error {
	var validationCtx = valid.NewValidationCtx()
	validationCtx.Add("greater", valid.Greater)
	validationCtx.Add(
		"required", valid.WrapValidator(
			func(s string) error {
				if len(s) == 0 {
					return xerrors.New("Value is required")
				}
				return nil
			},
		),
	)

	if err := valid.Struct(validationCtx, conf); err != nil {
		return xerrors.Errorf("Config validation failed: %+v", err)
	}
	return nil
}

func NewConfigFromBytes(data []byte) (*Config, error) {
	conf := &Config{}
	if err := yaml.Unmarshal(data, conf); err != nil {
		return nil, err
	}
	return conf, nil
}
