package consts

type CredentialsMethod string

const (
	OAuthMethod                  CredentialsMethod = "OAuth"
	SandboxSessionMethod         CredentialsMethod = "SBSession"
	ExternalSandboxSessionMethod CredentialsMethod = "ESBSession"
)

// NB: Http headers in canonical form. See tests.
const (
	AuthorizationHeader = "Authorization"
	UserAgentHeader     = "User-Agent"

	ForwardedForHeader  = "X-Forwarded-For"
	ForwardedHostHeader = "X-Forwarded-Host"
	RequestIDHeader     = "X-Request-Id"
)
