package consts

import (
	"net/textproto"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestCanonicalHeaders(t *testing.T) {
	cases := []string{
		AuthorizationHeader,
		UserAgentHeader,

		ForwardedForHeader,
		ForwardedHostHeader,
		RequestIDHeader,
	}
	for _, item := range cases {
		require.Equal(t, textproto.CanonicalMIMEHeaderKey(item), item)
	}
}
