package consts

import (
	"github.com/gofrs/uuid"

	"a.yandex-team.ru/tasklet/api/v2"
)

// Type aliases for common protobuf types

type Permissions []*taskletv2.PermissionsSubject

type ExecutionID string

func (j ExecutionID) String() string {
	return string(j)
}

type TaskletID string

func (t TaskletID) String() string {
	return string(t)
}

type RequestID uuid.UUID

var NilRequestID = RequestID(uuid.Nil)

func (r RequestID) String() string {
	return uuid.UUID(r).String()
}

func NewRequestID() RequestID {
	return RequestID(uuid.Must(uuid.NewV4()))
}

func RequestIDFromString(s string) (RequestID, error) {
	v, err := uuid.FromString(s)
	return RequestID(v), err
}
