package xmodels

import (
	"testing"
	"time"

	"github.com/gofrs/uuid"
	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/types/known/timestamppb"

	"a.yandex-team.ru/tasklet/api/v2"
)

func TestValidateNamespace(t *testing.T) {
	tests := []struct {
		name    string
		ns      *taskletv2.Namespace
		wantErr bool
	}{
		{
			"ok",
			&taskletv2.Namespace{
				Meta: &taskletv2.NamespaceMeta{
					Id:        uuid.Must(uuid.NewV4()).String(),
					Name:      "foo",
					AccountId: "abc:bar",
					CreatedAt: timestamppb.New(time.Now()),
				},
				Spec: &taskletv2.NamespaceSpec{},
			},
			false,
		},
		{
			"fail",
			&taskletv2.Namespace{
				Meta: &taskletv2.NamespaceMeta{
					Id:        "adfasf",
					Name:      "foo",
					AccountId: "abc:bar",
					CreatedAt: timestamppb.New(time.Now()),
				},
				Spec: &taskletv2.NamespaceSpec{},
			},
			true,
		},
	}
	for _, tt := range tests {
		t.Run(
			tt.name, func(t *testing.T) {
				err := ValidateNamespace(tt.ns)
				if tt.wantErr {
					require.NotNil(t, err)
				} else {
					require.Nil(t, err)
				}
			},
		)
	}
}
