package corpus

import (
	"embed"
	"encoding/json"
	"strings"

	"a.yandex-team.ru/sandbox/common/go/models"
)

const (
	fileSuffix = ".json"
)

//go:embed *.json
var embeddedFS embed.FS

func Get(name string) (*models.TaskNew, error) {
	fullName := name + fileSuffix
	if bytes, err := embeddedFS.ReadFile(fullName); err == nil {
		spec := &models.TaskNew{}
		err := json.Unmarshal(bytes, spec)
		if err != nil {
			return nil, err
		} else {
			return spec, nil
		}
	} else {
		return nil, err
	}
}

func MustGet(name string) *models.TaskNew {
	rv, err := Get(name)
	if err != nil {
		panic(err)
	}
	return rv
}

func List() []string {
	var embedded []string
	items, _ := embeddedFS.ReadDir(".")
	for _, item := range items {
		if !item.IsDir() && strings.HasSuffix(item.Name(), fileSuffix) {
			name := item.Name()[0 : len(item.Name())-len(fileSuffix)]
			embedded = append(embedded, name)
		}
	}
	return embedded
}
