package requestctx

import (
	"context"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestGetSetAuth(t *testing.T) {
	ctx := context.Background()

	{
		subj, err := GetAuthSubject(ctx)
		require.ErrorIs(t, err, ErrNoAuth)
		require.Equal(t, InvalidSubject, subj.GetKind())
	}

	newSubj := NewUser("super_user")
	ctxOne := WithObject(ctx, newSubj)

	{
		subj, err := GetAuthSubject(ctxOne)
		require.NoError(t, err)
		require.Equal(t, UserSubject, subj.GetKind())
		require.Equal(t, subj, newSubj)
	}

	ctxTwo := WithUserName(ctxOne, "super_user")

	{
		subj, err := GetAuthSubject(ctxTwo)
		require.NoError(t, err)
		require.Equal(t, UserSubject, subj.GetKind())
		require.Equal(t, subj, newSubj)
	}

	require.Panics(t, func() { _ = WithUserName(ctxOne, "other_user") })
}

func TestAuthFmt(t *testing.T) {
	items := []AuthSubject{
		NewInvalid(),
		NewUser("prince_of_persia"),
		NewSandboxTask(86763),
		NewExecutionID("uuid-uuid-uuid-uuid"),
	}

	for _, item := range items {
		require.NotEmpty(t, item.ToString())
	}
}
