package requestctx

import (
	"context"

	"github.com/mitchellh/copystructure"
)

type featureFlagType string

func WithFeature(ctx context.Context, name string, value interface{}) context.Context {
	valueCopy := copystructure.Must(copystructure.Copy(value))
	return context.WithValue(ctx, featureFlagType(name), valueCopy)
}

func GetFeature(ctx context.Context, name string) interface{} {
	return ctx.Value(featureFlagType(name))
}
